<?php

require '../connection.php';

if(array_key_exists('submit',$_POST)) {
	$target_dir = "data/";
	$target_file = $target_dir . basename($_FILES["exceldata"]["name"]);
	$uploadOk = 1;

	if (@move_uploaded_file($_FILES["exceldata"]["tmp_name"], $target_file)) {
		$message = "The file <b>". basename( $_FILES["exceldata"]["name"]). "</b> has been uploaded.";
	} else {
		$message = "Sorry, there was an error uploading your file.";
		$uploadOk = 0;
	}

	if(!preg_match("/^[0-9]+$/", $_POST['gameid'])) {
		$message = "Please enter a proper Game ID.";
		$uploadOk = 0;
	} else {
		$gameid = $_POST['gameid'];
	}
}

if(isset($uploadOk) && $uploadOk) {
	//$inputFileName = './data/Excel_Stats_Output.xlsx';
	$inputFileName = $target_file;

	include './Classes/PHPExcel.php';
	include './Classes/MyReadFilter.php';
	include './dataParse.php';
}

if(array_key_exists('import', $_POST)) {
	$gameId = unserialize($_POST['gameid']);
	$teamStats = unserialize(base64_decode($_POST['teamstats']));
	$playerStats = unserialize(base64_decode($_POST['playerstats']));

	// Check to make sure data is held in arrays
	if(is_array($teamStats) && is_array($playerStats)) {

		$insert_stats = '';

		$imported = TRUE;

		// Build SQL INSERT Queries

		// Game Scores
		// prepare and bind
		/*
		$stmt = $db->prepare("INSERT INTO game (id_team_home, id_team_away, team_home_points, team_away_points, team_home_points_half, team_away_points_half) VALUES (?,?,?,?,?,?)");
		$stmt->bind_param("iiiiii", $teamStats[2][34], $teamStats[1][34], $teamStats[2][38], $teamStats[1][38], $teamStats[2][40], $teamStats[1][40]);
		$stmt->execute();
		$insert_stats .= '<h4>Table `game` INSERT ID : '.$stmt->insert_id.'</h4>';
		*/

		// Update game Table
		// prepare and bind
		$stmt = $db->prepare("UPDATE game SET team_home_points=?, team_away_points=?, team_home_points_half=?, team_away_points_half=? WHERE id_team_home=? AND id_team_away=? AND team_home_points IS NULL AND team_away_points IS NULL");
		$stmt->bind_param("iiiiii", $teamStats[2][38], $teamStats[1][38], $teamStats[2][40], $teamStats[1][40], $teamStats[2][34], $teamStats[1][34]);
		if($stmt->execute()) {
			$insert_stats .= '<h4>Table `game` Updated!</h4>';
		}

		$stmt = $db->prepare("SELECT id_team, id_game FROM team_stats WHERE (id_team=? AND id_game=?) OR (id_team=? AND id_game=?)");
		$stmt->bind_param("iiii", $teamStats[1][34], $gameId, $teamStats[2][34], $gameId);
		if($stmt->execute()) {
			$stmt->store_result();
			if($stmt->num_rows < 1) {
				$insert_stats .= '<h4>Table `team_stats` INSERT IDs : ';

				// Team Stats
				// prepare and bind
				$stmt = $db->prepare("INSERT INTO team_stats (id_team, id_game, PTS, PTSA, FGM, FGA, 3PM, 3PA, FTM, FTA, REB, AST, STL, BLK, `TO`, FT, result) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
				$stmt->bind_param("iiiiiiiiiiiiiiiis", $team_id, $game_id, $pts, $ptsa, $fgm, $fga, $_3pm, $_3pa, $ftm, $fta, $reb, $ast, $stl, $blk, $to, $ft, $result);

				// Away team
				$team_id = $teamStats[1][34];
				$game_id = $gameId;
				$pts = $teamStats[1][38];
				$ptsa = $teamStats[2][38];
				$fgm = $teamStats[1][41];
				$fga = $teamStats[1][42];
				$_3pm = $teamStats[1][43];
				$_3pa = $teamStats[1][44];
				$ftm = $teamStats[1][45];
				$fta = $teamStats[1][46];
				$reb = $teamStats[1][54];
				$ast = $teamStats[1][50];
				$stl = $teamStats[1][49];
				$blk = $teamStats[1][48];
				$to = $teamStats[1][57];
				$ft	= $teamStats[1][55];
				$result = ($pts < $ptsa) ? 'L' : 'W' ;

				if(!$stmt->execute()) {
					$imported = FALSE;
				} else {
					$insert_stats .= $stmt->insert_id.', ';
				}

				// Home team
				$team_id = $teamStats[2][34];
				$game_id = $gameId;
				$pts = $teamStats[2][38];
				$ptsa = $teamStats[1][38];
				$fgm = $teamStats[2][41];
				$fga = $teamStats[2][42];
				$_3pm = $teamStats[2][43];
				$_3pa = $teamStats[2][44];
				$ftm = $teamStats[2][45];
				$fta = $teamStats[2][46];
				$reb = $teamStats[2][54];
				$ast = $teamStats[2][50];
				$stl = $teamStats[2][49];
				$blk = $teamStats[2][48];
				$to = $teamStats[2][57];
				$ft	= $teamStats[2][55];
				$result = ($pts < $ptsa) ? 'L' : 'W' ;

				if(!$stmt->execute()) {
					$imported = FALSE;
				}	else {
					$insert_stats .= $stmt->insert_id.'</h4>';
				}
			}
		}


		// Game Stats
		// prepare and bind
		$stmt = $db->prepare("INSERT INTO game_stats (id_player, id_game, PTS, FGM, FGA, 3PM, 3PA, FTM, FTA, REB, AST, STL, BLK, `TO`, FT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$stmt->bind_param("iiiiiiiiiiiiiii",$player_id, $game_id, $pts, $fgm, $fga, $_3pm, $_3pa, $ftm, $fta, $reb, $ast, $stl, $blk, $to, $ft);

		$insert_stats .= '<h4>Table `game_stats` INSERT IDs :<br>';

		// Individual Players
		for($i = 1; $i <= (count($playerStats)-1); $i++) {
			$player_id = $playerStats[$i][66];
			$game_id = $gameId;
			$pts = $playerStats[$i][82];
			$fgm = $playerStats[$i][76];
			$fga = $playerStats[$i][77];
			$_3pm = $playerStats[$i][78];
			$_3pa = $playerStats[$i][79];
			$ftm = $playerStats[$i][80];
			$fta = $playerStats[$i][81];
			$reb = $playerStats[$i][89];
			$ast = $playerStats[$i][85];
			$stl = $playerStats[$i][84];
			$blk = $playerStats[$i][83];
			$to = $playerStats[$i][92];
			$ft	= $playerStats[$i][90];

			$stmt_stats = $db->prepare("SELECT id_player, id_game FROM game_stats WHERE id_player=? AND id_game=?");
			$stmt_stats->bind_param("ii", $player_id, $game_id);
			if($stmt_stats->execute()) {
				$stmt_stats->store_result();
				if($stmt_stats->num_rows < 1) {
					if(!$stmt->execute()) {
						$imported = FALSE;
					} else {
						$insert_stats .= $stmt->insert_id.', ';
					}
				}
			}
		}

		$insert_stats .= '</h4>';

		$message = ($imported) ? '<div class="alert alert-success" role="alert"><b>Data Imported!</b><br><br>'.$insert_stats.'</div>' : '<div class="alert alert-danger" role="alert"><b>Uh oh! Something went wrong...</b></div>';
	} else {
		$message = '<div class="alert alert-danger" role="alert"><b>Uh oh! There was an error transferring the data. Please see the data below.</b></div><pre><b>Team</b><hr><br>'.var_export($teamStats,1).'</pre><pre><b>Player</b><hr><br>'.var_export($playerStats,1).'</pre>';
	}
}

?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
		<title>Data Import</title>

		<!-- Bootstrap -->
		<!-- Latest compiled and minified CSS -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
		<!-- Optional theme -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap-theme.min.css">

		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>

	<body>
		<div class="row" style="margin-top: 30px;">
			<div class="col-md-5 col-md-offset-3">
				<form class="form-inline" method="post" enctype="multipart/form-data">
					<div class="form-group">
						<label class="sr-only" for="gameid">Game ID</label>
						<input type="text" class="form-control" name="gameid" id="gameid" placeholder="Game ID" required>
					</div>
					<div class="form-group">
						<label class="sr-only" for="excelData">File input</label>
						<input type="file" name="exceldata" id="excelData">
					</div>
					<button type="submit" name="submit" class="btn btn-default">Upload</button>
				</form>
				<?php
				if(isset($message)) echo "<br><p>$message</p>";
				?>
			</div>
		</div>

		<?php
		if(isset($uploadOk) && $uploadOk) {
			?>
			<div class="row">
				<div class="col-md-5 col-md-offset-3">
					<br>
					<form class="form-inline" method="post">
						<p class="form-group">Please review the data below. Once verified, click "Import".</p>
						<input type="hidden" name="gameid" value='<?php echo serialize($gameid);?>'>
						<input type="hidden" name="teamstats" value='<?php echo base64_encode(serialize($teamStatsArray));?>'>
						<input type="hidden" name="playerstats" value='<?php echo base64_encode(serialize($playerStatsArray));?>'>
						<button type="submit" name="import" class="btn btn-default">Import</button>
					</form>
					<br>
					<?php if(isset($gameid)) echo "Game ID: <b>$gameid</b>";?>
					<br>
					<table class="table table-striped">
						<?php
						echo '<thead><tr>';
						foreach($teamStatsArray[0] as $value) {
							echo "<td><b>$value</b></td>";
						}
						echo '</tr></thead>';
						echo '<tr>';
						foreach($teamStatsArray[1] as $value) {
							echo "<td>$value</td>";
						}
						echo '</tr>';
						echo '<tr>';
						foreach($teamStatsArray[2] as $value) {
							echo "<td>$value</td>";
						}
						echo '</tr>';
						?>
					</table>

					<table class="table table-striped">
						<?php
						$row = 1;
						foreach($playerStatsArray as $player) {

							if($row == 1) {
								echo '<thead><tr>';
							} else {
								echo '<tr>';
							}

							foreach($player as $value) {
								if($row == 1) {
									echo "<td><b>$value</b></td>";
								} else {
									echo "<td>$value</td>";
								}
							}

							if($row == 1) {
								echo '</tr></thead>';
							} else {
								echo '</tr>';
							}

							$row++;
						}
						?>
					</table>
				</div>
			</div>
			<?php
		}
		?>

		<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
		<!-- Latest compiled and minified JavaScript -->
		<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>
	</body>
</html>
