<?php

try {
	/**  Identify the type of $inputFileName  **/
	$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	
	/**  Create an Instance of our Read Filter, passing in the cell range  **/ 
	$filterSubset = new MyReadFilter('AI','CO');
	
	/**  Create a new Reader of the type that has been identified  **/
	$objReader = PHPExcel_IOFactory::createReader($inputFileType);
	
	/**  Tell the Reader that we want to use the Read Filter  **/ 
	$objReader->setReadFilter($filterSubset);
	
	/**  Load $inputFileName to a PHPExcel Object  **/
	$objPHPExcel = $objReader->load($inputFileName);
	
} catch (Exception $e) {
	die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) 
	. '": ' . $e->getMessage());
}

//  Get worksheet dimensions
$sheet = $objPHPExcel->getSheet(0);
$highestRow = $sheet->getHighestRow();
$highestColumn = $sheet->getHighestColumn();

// Select columns we want to read
$teamStatColumns = array(34,38,40,41,42,43,44,45,46,47,48,49,50,54,55,57);
$playerStatColumns = array(66,67,76,77,78,79,80,81,82,83,84,85,89,90,92);

$teamStatsArray = array();
$playerStatsArray = array();

$teamStats = FALSE;

//  Loop through each row of the worksheet in turn
for ($row = 1; $row <= $highestRow; $row++) {
    //  Read a row of data into an array
    $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, 
    NULL, TRUE, FALSE);
	
	// Parse Team Stats
	if($rowData[0][34] != null ) {
		$teamDataSingle = $rowData[0];
		
		foreach($rowData[0] as $k=>$v) {
			
			if(!in_array($k, $teamStatColumns)) {
				unset($teamDataSingle[$k]);
			}
		}
		
		//array_push($teamStatsArray, $teamDataSingle);
		
		if(!$teamStats) {
			if(count($teamStatsArray) <= 1) {
				array_push($teamStatsArray, $teamDataSingle);
			} else if($teamStatsArray[1][34] != $teamDataSingle[34]) {
				array_push($teamStatsArray, $teamDataSingle);
				$teamStats = TRUE;
			}
		}
	}
	
	// Parse Player Stats
	if($rowData[0][66] != null) {
		$playerDataSingle = $rowData[0];
		
		foreach($rowData[0] as $k=>$v) {
			
			if(!in_array($k, $playerStatColumns)){
				unset($playerDataSingle[$k]);
			}
		}
		
		if((array_sum($playerDataSingle) - ($playerDataSingle[66] + $playerDataSingle[67])) > 0 || $row == 1) {
			array_push($playerStatsArray, $playerDataSingle);
		}
	}
}