<?php

/**  Define a Read Filter class implementing PHPExcel_Reader_IReadFilter  */ 
class MyReadFilter implements PHPExcel_Reader_IReadFilter 
{ 
    private $_columns  = array(); 

    /**  Get the list of columns to read  */ 
    public function __construct($columns_start, $columns_end) {
        $this->_columns  = $this->xrange($columns_start, $columns_end); 
    }
	
	private function xrange($start, $end, $limit = 1000) {
		
		$l = array();
		while ($start !== $end && count($l) < $limit) {
			$l[] = $start;
			$start ++;
		}
		$l[] = $end;
		return $l;
	}

    public function readCell($column, $row, $worksheetName = '') { 
        //  Only read the rows and columns that were configured
        if (in_array($column,$this->_columns)) { 
			return true; 
		}
        return false; 
    } 
}