/* Write here your custom javascript codes */

jQuery(document).ready(function() {

  $('[data-toggle="tooltip"]').tooltip();

  function get_terms_list(){
    $.ajax({
      url: terms_list_url
    }).done(function(data){
      var terms = jQuery.parseJSON(data);

      $.each(terms, function(key, value) {
        $('#termsList').append($('<option>', { value : key }).text(value));
      });
    });
  }
  get_terms_list();
  $('#termList').click(function(){
    get_terms_list();
  });

  $('#changePasswordForm').ajaxForm({
    success: function(response){
        var response = jQuery.parseJSON(response);

        if(response.status){
          $('#passwordResponse').removeClass('hide');
          $('#passwordMessage').removeClass('alert-danger').addClass('alert-success').text(response.message);
          setTimeout(function(){
            $('#changePassword').modal('toggle');
            $('#passwordResponse').addClass('hide');
          }, 1800);
        } else {
          $('#passwordResponse').removeClass('hide');
          $('#passwordMessage').addClass('alert-danger').removeClass('alert-success').text(response.message);
        }
      },
    clearForm: true,
    resetForm: true
  });

  $('#updateEmailForm').ajaxForm({
    success: function(response){
        var response = jQuery.parseJSON(response);

        if(response.status){
          $('#emailResponse').removeClass('hide');
          $('#emailMessage').removeClass('alert-danger').addClass('alert-success').text(response.message);
          setTimeout(function(){
            $('#updateEmail').modal('toggle');
            $('#emailResponse').addClass('hide');
          }, 1800);
        } else {
          $('#emailResponse').removeClass('hide');
          $('#emailMessage').addClass('alert-danger').removeClass('alert-success').text(response.message);
        }
      },
    clearForm: true,
    resetForm: true
  });

  var query = {
    all: {
      results: '',
      offset: '',
      orderby: '',
      orderdirection: 'ASC',
    },
    archive: {
      results: '',
      offset: '',
      orderby: '',
      orderdirection: 'ASC',
    }
  };

  var archive = 0;

  var load_page = function(archive){
    return archive ? $("#archiveList") : $("#invoiceList");
  }

  $("a.invoices").click(function(){
    archive = 0;
    load_page(false).load(invoice_url({
      orderby: query.all.orderby,
      orderdirection: query.all.orderdirection,
      results: query.all.results,
      offset: query.all.offset,
      archive: archive
    }));
  });

  $("a.archives").click(function(){
    archive = 1;
    load_page(true).load(invoice_url({
      orderby: query.archive.orderby,
      orderdirection: query.archive.orderdirection,
      results: query.archive.results,
      offset: query.archive.offset,
      archive: archive
    }));
  });

  $(document).on('click', "a[href='#order']", function(event){
    event.preventDefault();

    current_query = (!archive) ? query.all : query.archive;
    current_query.orderby = $(this).data("order-by");
    current_query.orderdirection = (current_query.orderdirection == 'DESC') ? 'ASC' : 'DESC' ;

    //invoice_url = invoices_url+'?orderby='+orderby+'&orderdirection='+orderdirection+'&results='+results+'&offset='+offset;
    load_page(archive).load(invoice_url({
      orderby: current_query.orderby,
      orderdirection: current_query.orderdirection,
      results: current_query.results,
      offset: current_query.offset,
      archive: archive
    }));
  });

  $(document).on('change', '#resultsPerPage', function(){

    current_query = (!archive) ? query.all : query.archive;
    current_query.results = $(this).val();

    //invoice_url = invoices_url+'?orderby='+orderby+'&orderdirection='+orderdirection+'&results='+results+'&offset='+offset+"&archive="+archive;
    load_page(archive).load(invoice_url({
      orderby: current_query.orderby,
      orderdirection: current_query.orderdirection,
      results: current_query.results,
      offset: current_query.offset,
      archive: archive
    }));
  });

  $(document).on('click', '.invoicesPage', function(event){
    event.preventDefault();

    current_query = (!archive) ? query.all : query.archive;
    current_query.offset = $(this).data('offset');

    //invoice_url = invoices_url+'?orderby='+orderby+'&orderdirection='+orderdirection+'&results='+results+'&offset='+offset;
    load_page(archive).load(invoice_url({
      orderby: current_query.orderby,
      orderdirection: current_query.orderdirection,
      results: current_query.results,
      offset: current_query.offset,
      archive: archive
    }));
  });

  $(document).on('click','.deleteInvoice',function(event){
    event.preventDefault();

    if(confirm("Are you sure you want to delete this invoice?")){
      var hash_id = $(this).data('hash-id');
      $.get(delete_invoice_url+"/"+hash_id, function(data){
        if(data == 0){
          alert("Cannot delete paid invoices.")
        }
      });

      current_query = (!archive) ? query.all : query.archive;

      load_page(archive).load(invoice_url({
        orderby: current_query.orderby,
        orderdirection: current_query.orderdirection,
        results: current_query.results,
        offset: current_query.offset,
        archive: archive
      }));
    }
  });

  $(document).on('click','.archiveInvoice',function(event){
    event.preventDefault();

    confirmation = (!archive) ? confirm("Are you sure you want to archive this invoice?") : true ;

    if(confirmation){
      var hash_id = $(this).data('hash-id');
      if(archive) {
        hash_id = hash_id + "/0";
      }
      $.get(archive_invoice_url+"/"+hash_id);

      current_query = (!archive) ? query.all : query.archive;

      load_page(archive).load(invoice_url({
        orderby: current_query.orderby,
        orderdirection: current_query.orderdirection,
        results: current_query.results,
        offset: current_query.offset,
        archive: archive
      }));
    }
  });

  $(document).on('click', '#sendReminderEmail', function(event){
    event.preventDefault();

    $.ajax({
        type: 'POST',
        url:  $(this).attr('href')+'/'+$(this).data('invoice-hash')+'/invoice_reminder',
        data: {
          to: $(this).data('to-email'),
        },
        dataType: "json",
        success: function (response) {
          $('#sendReminderEmail').parent().append('<br>'+response.message);
        }
    });
  });

  $('#userAutocomplete').autocomplete({
    lookup: function (query, done) {
            $.ajax({
                type: 'GET',
                url:  user_list_url + "/" + query,
                dataType: "json",
                success: function (response) {
                    done(response);
                }
            });
        }
  });

  $('.itemAutocomplete').on("focus", function(){
    $(this).autocomplete({
      lookup: function (query, done) {
              $.ajax({
                  type: 'GET',
                  url:  item_list_url + "/" + query,
                  dataType: "json",
                  success: function (response) {
                    done(response);
                  }
              });
          },
      onSelect: function(suggestion){
        $(this).parents("div.itemDetails").find("input[name^='itemDescription']").val(suggestion.description);
        $(this).parents("div.itemDetails").find("input[name^='itemCost']").val(suggestion.cost);
        $(this).parents("div.itemDetails").find("select[name^='itemType']").val(suggestion.type);
      }
    });
  });

  $('#addUserForm').ajaxForm({
    success: function(response){
        var response = jQuery.parseJSON(response);

        if(response.status){
          $('#addUserResponse').removeClass('hide');
          $('#addUserMessage').removeClass('alert-danger').addClass('alert-success').text(response.message);
          setTimeout(function(){
            $('#addUser').modal('toggle');
            $('#addUserResponse').addClass('hide');
          }, 1800);
        } else {
          $('#addUserResponse').removeClass('hide');
          $('#addUserMessage').addClass('alert-danger').removeClass('alert-success').text(response.message);
        }
      },
    clearForm: true,
    resetForm: true
  });

  $('#createInvoiceForm').ajaxForm({
    success: function(response){

        try {
          var response = jQuery.parseJSON(response);
        }
        catch(err) {
          console.log(response);
        }

        if(response.dump){
          console.log(response.dump);
        }

        if(response.status){
          $('#createInvoiceMessage').html(response.message).addClass('alert-success').removeClass('alert-danger').fadeIn("slow",function(){
            $(this).addClass('in').removeClass('hide out');
          });
          $("html, body").animate({ scrollTop: 0 }, "slow");
          setTimeout(function(){
            document.getElementById("createInvoiceForm").reset();
            $('#itemDetailsMaster:not(.hide)').remove();
            $('#createInvoiceMessage').hide("slow", function(){
              $(this).addClass('out hide').removeAttr("style");
            });
          }, 1800);

        } else {
          $('#createInvoiceMessage').addClass('alert-danger').removeClass('hide alert-success').html(response.message);
          $("html, body").animate({ scrollTop: 0 }, "slow");
        }
      },
  });

  $('#addItemForm').click(function(){
    $('#itemDetailsMaster').clone(true).removeClass('hide').appendTo($('#itemList'));
  });

  $('.createInvoiceReset').click(function(){
    $('#createInvoiceMessage').addClass('hide');
    $('#itemDetailsMaster:not(.hide)').remove();
  });

  $('a.remove-item').click(function(e){
    $(this).parents('div.itemDetails').remove();
    e.preventDefault();
  });

  $('#payment-terms-agreement').change(function(){
    this.checked ? $('.payment-form').removeClass("hide") : $('.payment-form').addClass("hide");
  });
});
